<?php

if ( ! class_exists( 'Avada_AvadaRedux_Get_GoogleFonts' ) ) {
	class Avada_AvadaRedux_Get_GoogleFonts {

		private static $instance = null;

		public $fonts = array();

		private function __construct() {
			$this->fonts = $this->get_fonts_array();
		}

		public static function get_instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		public function get_fonts_array() {
			// If we have it cached, then return it from a transient.
			$transient = get_site_transient( 'avada_avadaredux_googlefonts' );
			if ( $transient ) {
				return $transient;
			}
			// If it's not cached then cache for a week and return it.
			$fonts = $this->get_from_api();
			set_site_transient( 'avada_avadaredux_googlefonts', $fonts, 7 * 24 * HOUR_IN_SECONDS );
			return $fonts;
		}

		private function get_from_api() {
			// The path to the PHP array file containing the fonts.
			// This is auto-generated by running "grunt googlefonts"
			$path = wp_normalize_path( dirname( __FILE__ ) . '/googlefonts-array.php' );
			// Get the contents of the file
			$fonts_array = include $path;

			$final_fonts = array();
			if ( isset( $fonts_array['items'] ) ) {
				$all_variants = array();

				foreach ( $fonts_array['items'] as $font ) {
					// If font-family is not set then skip this item.
					if ( ! isset( $font['family'] ) ) {
						continue;
					}
					$final_fonts[ $font['family'] ] = array(
						'variants' => array(),
						'subsets'  => array(),
					);
					if ( isset( $font['variants'] ) && is_array( $font['variants'] ) ) {
						foreach ( $font['variants'] as $variant ) {
							$final_fonts[ $font['family'] ]['variants'][] = $this->convert_font_variants( $variant );
						}
					}
					if ( isset( $font['subsets'] ) && is_array( $font['subsets'] ) ) {
						foreach ( $font['subsets'] as $subset ) {
							$final_fonts[ $font['family'] ]['subsets'][] = $this->convert_font_subsets( $subset );
						}
					}
				}
			}
			return $final_fonts;
		}

		private function convert_font_variants( $variant ) {
			$variants = array(
				'regular'   => array( 'id' => '400',       'name' => esc_attr__( 'Normal 400', 'Avada' ) ),
				'italic'    => array( 'id' => '400italic', 'name' => esc_attr__( 'Normal 400 Italic', 'Avada' ) ),
				'100'       => array( 'id' => '100',       'name' => esc_attr__( 'Ultra-Light 100', 'Avada' ) ),
				'200'       => array( 'id' => '200',       'name' => esc_attr__( 'Light 200', 'Avada' ) ),
				'300'       => array( 'id' => '300',       'name' => esc_attr__( 'Book 300', 'Avada' ) ),
				'500'       => array( 'id' => '500',       'name' => esc_attr__( 'Medium 500', 'Avada' ) ),
				'600'       => array( 'id' => '600',       'name' => esc_attr__( 'Semi-Bold 600', 'Avada' ) ),
				'700'       => array( 'id' => '700',       'name' => esc_attr__( 'Bold 700', 'Avada' ) ),
				'700italic' => array( 'id' => '700italic', 'name' => esc_attr__( 'Bold 700 Italic', 'Avada' ) ),
				'900'       => array( 'id' => '900',       'name' => esc_attr__( 'Ultra-Bold 900', 'Avada' ) ),
				'900italic' => array( 'id' => '900italic', 'name' => esc_attr__( 'Ultra-Bold 900 Italic', 'Avada' ) ),
				'100italic' => array( 'id' => '100italic', 'name' => esc_attr__( 'Ultra-Light 100 Italic', 'Avada' ) ),
				'300italic' => array( 'id' => '300italic', 'name' => esc_attr__( 'Book 300 Italic', 'Avada' ) ),
				'500italic' => array( 'id' => '500italic', 'name' => esc_attr__( 'Medium 500 Italic', 'Avada' ) ),
				'800'       => array( 'id' => '800',       'name' => esc_attr__( 'Extra-Bold 800', 'Avada' ) ),
				'800italic' => array( 'id' => '800italic', 'name' => esc_attr__( 'Extra-Bold 800 Italic', 'Avada' ) ),
				'600italic' => array( 'id' => '600italic', 'name' => esc_attr__( 'Semi-Bold 600 Italic', 'Avada' ) ),
				'200italic' => array( 'id' => '200italic', 'name' => esc_attr__( 'Light 200 Italic', 'Avada' ) ),
			);
			if ( array_key_exists( $variant, $variants ) ) {
				return $variants[ $variant ];
			}
			return array(
				'id'   => $variant,
				'name' => $variant,
			);
		}

		private function convert_font_subsets( $subset ) {
			$subsets = array(
				'greek-ext'    => esc_attr__( 'Greek Extended', 'Avada' ),
				'greek'        => esc_attr__( 'Greek', 'Avada' ),
				'cyrillic-ext' => esc_attr__( 'Cyrillic Extended', 'Avada' ),
				'cyrillic'     => esc_attr__( 'Cyrillic', 'Avada' ),
				'latin-ext'    => esc_attr__( 'Latin Extended', 'Avada' ),
				'latin'        => esc_attr__( 'Latin', 'Avada' ),
				'vietnamese'   => esc_attr__( 'Vietnamese', 'Avada' ),
				'arabic'       => esc_attr__( 'Arabic', 'Avada' ),
				'gujarati'     => esc_attr__( 'Gujarati', 'Avada' ),
				'devanagari'   => esc_attr__( 'Devanagari', 'Avada' ),
				'bengali'      => esc_attr__( 'Bengali', 'Avada' ),
				'hebrew'       => esc_attr__( 'Hebrew', 'Avada' ),
				'khmer'        => esc_attr__( 'Khmer', 'Avada' ),
				'tamil'        => esc_attr__( 'Tamil', 'Avada' ),
				'telugu'       => esc_attr__( 'Telugu', 'Avada' ),
				'thai'         => esc_attr__( 'Thai', 'Avada' ),
			);
			if ( array_key_exists( $subset, $subsets ) ) {
				return array(
					'id'   => $subset,
					'name' => $subsets[ $subset ],
				);
			}
			return array(
				'id'   => $subset,
				'name' => ucfirst( $subset )
			);
		}
	}
}

$fonts = Avada_AvadaRedux_Get_GoogleFonts::get_instance();
return $fonts->fonts;
